/*
    VERSION: 1.0.1
    If you find anything which goes wrong or you need support at something please go to https://barrex.stream/ and join the discord
*/

const WEBSOCKET_URL = 'ws://127.0.0.1:8080';
let websocket;
let goal = 0;
let current = 0;
let includeNumbersInName = false;
let goalName = '';

let currencyBefore;
let currencyAfter;

let showCurrent = true;
let showGoal = true;

const params = new Proxy(new URLSearchParams(window.location.search), {
    get: (searchParams, prop) => searchParams.get(prop),
});

function connectToWebsocket() {
    websocket = new WebSocket(WEBSOCKET_URL);
    websocket.onopen = () => subscribeToWebsocket();
    websocket.onmessage = event => eventReceived(JSON.parse(event.data));
    websocket.onclose = () => setTimeout(connectToWebsocket, 5000);
}

function subscribeToWebsocket() {
    websocket.send(
        JSON.stringify({
            "request": "Subscribe",
            "events": {
                "General": ["Custom"]
            },
            "id": "GoalProgress"
        })
    );
}

function eventReceived(data) {
    if (data && data.status === 'ok') {
    } else if (data?.data?.data) {
        const widgetData = JSON.parse(data.data.data);
        if (widgetData.widget === 'GoalProgress') {
            handleData(widgetData);
        }
    }
}

function handleData(widgetData) {
    const goalId = widgetData.id;

    if (params.id === goalId) {
        const name = widgetData.name;
        const progress = widgetData.current;
        const goal = widgetData.goal;

        const backgroundColor = widgetData.backgroundColor;
        const progressColor = widgetData.progressColor;
        const color = widgetData.color;
        const borderRadius = widgetData.borderRadius;
        const borderRadiusProgress = widgetData.borderRadiusProgress;
        const borderWidth = widgetData.borderWidth;
        const borderColor = widgetData.borderColor;
        const height = widgetData.height;
        const fontSize = widgetData.fontSize;
        const fontName = widgetData.fontName;
        const includeNumbersInName = widgetData.includeNumbersInName;
        const currencyBefore = widgetData.currencyBefore;
        const currencyAfter = widgetData.currencyAfter;
        const showCurrent = widgetData.showCurrent;
        const showGoal = widgetData.showGoal;
        const textShadow = widgetData.textShadow;

        const goalProgress = document.getElementById('goal-progress');

        if (this.currencyAfter === undefined || currencyAfter !== undefined) {
            this.currencyAfter = currencyAfter !== undefined ? currencyAfter : '';
        }

        if (this.currencyBefore === undefined || currencyBefore !== undefined) {
            this.currencyBefore = currencyBefore !== undefined ? currencyBefore : '';
        }

        if (this.showCurrent === undefined || showCurrent !== undefined) {
            this.showCurrent = showCurrent !== undefined ? showCurrent : true;
        }

        if (this.showGoal === undefined || showGoal !== undefined) {
            this.showGoal = showGoal !== undefined ? showGoal : true;
        }

        if (includeNumbersInName !== undefined) {
            this.includeNumbersInName = includeNumbersInName;
            setNumberVisibility();
        }

        if (backgroundColor !== undefined) {
            setBackgroundColor(backgroundColor);
        }

        if (borderRadius !== undefined) {
            setBorderRadius(borderRadius);
        }

        if (borderRadiusProgress !== undefined) {
            setBorderRadiusProgress(borderRadiusProgress);
        }

        if (borderWidth !== undefined) {
            setBorderWidth(borderWidth);
        }

        if (borderColor !== undefined) {
            setBorderColor(borderColor);
        }

        if (fontSize !== undefined) {
            setFontSize(fontSize);
        }

        if (height !== undefined) {
            setHeight(height);
        }

        if (progressColor !== undefined) {
            setProgressColor(progressColor);
        }

        if (color !== undefined) {
            setColor(color);
        }

        if (name !== undefined) {
            setGoalName(name);
        }
        if (goal !== undefined) {
            setGoal(goal);
        }
        if (progress !== undefined) {
            setCurrentProgress(progress);
        }

        if (fontName !== undefined) {
            loadCustomFont(fontName);
        }

        if (this.goal !== 0) {
            goalProgress.style.display = 'block';
            calculateProgress();
        } else {
            goalProgress.style.display = 'none';
        }

        if (textShadow !== undefined) {
            setTextShadow(textShadow);
        }
    }
}

function loadCustomFont(fontName) {
    WebFont.load({
        google: {
            families: [fontName]
        },
        active: function () {
            document.getElementById('goal-progress').style.fontFamily = `${fontName}`;
            document.getElementById('progress').style.fontFamily = `${fontName}`;
            document.getElementById('info').style.fontFamily = `${fontName}`;
        }
    });
}

function setFontSize(fontSize) {
    document.getElementById('goal-progress').style.fontSize = fontSize;
    document.getElementById('progress').style.fontSize = fontSize;
    document.getElementById('info').style.fontSize = fontSize;
}

function setHeight(height) {
    document.getElementById('progress-container').style.height = height;
    document.getElementById('goal-progress').style.height = height;
    document.getElementById('progress').style.height = height;
    document.getElementById('info').style.height = height;
}

function setBorderRadius(borderRadius) {
    document.getElementById('progress-container').style.borderRadius = borderRadius;
    document.getElementById('goal-progress').style.borderRadius = borderRadius;
    document.getElementById('info').style.borderRadius = borderRadius;
}

function setBorderRadiusProgress(borderRadius) {
    document.getElementById('progress').style.borderRadius = borderRadius;
}

function setBorderWidth(borderWidth) {
    const container = document.getElementById('progress-container');

    container.style.outlineWidth = borderWidth;
    container.style.outlineOffset = '-' + container.style.outlineWidth;
    container.style.outlineStyle = 'solid';
}

function setBorderColor(borderColor) {
    document.getElementById('progress-container').style.outlineColor = borderColor;
}

function setBackgroundColor(color) {
    document.getElementById('goal-progress').style.backgroundColor = color;
}

function setProgressColor(color) {
    document.getElementById('progress').style.backgroundColor = color;
}

function setColor(color) {
    document.getElementById('info').style.color = color;
}

function setCurrentProgress(progress) {
    this.current = progress;
    setCurrentText();
}

function getCurrentText() {
    return this.showCurrent ? `${this.currencyBefore}${this.current}${this.currencyAfter}` : '';
}

function setCurrentText() {
    const currentText = getCurrentText();
    const goalText = getGoalText();
    const divider = currentText === '' || goalText === '' ? '' : ' / ';
    if (this.includeNumbersInName) {
        document.getElementById('name').innerText = `${this.goalName} ${currentText}${divider}${goalText}`;
    } else {
        document.getElementById('current').innerText = `${currentText}`;
    }
}

function setGoalName(name) {
    this.goalName = name;
    document.getElementById('name').innerText = this.goalName;
}

function setGoal(goal) {
    this.goal = goal;
    setGoalText();
}

function getGoalText() {
    return this.showGoal ? `${this.currencyBefore}${this.goal}${this.currencyAfter}` : '';
}

function setGoalText() {
    document.getElementById('goal').innerText = getGoalText();
}

function setNumberVisibility() {
    if (this.includeNumbersInName) {
        document.getElementById('current').style.visibility = 'hidden';
        document.getElementById('goal').style.visibility = 'hidden';
    } else {
        document.getElementById('current').style.visibility = 'visible';
        document.getElementById('goal').style.visibility = 'visible';
    }
}

function setTextShadow(textShadow) {
    document.getElementById('info').style.textShadow = textShadow;
}

function calculateProgress() {
    let progress = (this.current / this.goal) * 100;
    progress = progress > 100 ? 100 : progress;
    progress = progress < 0 ? 0 : progress;
    document.getElementById('progress').style.width = `${progress}%`;
}

connectToWebsocket();