/*
    VERSION: 0.2
    If you find anything which goes wrong or you need support at something please go to https://barrex.stream/ and join the discord
*/

var r = document.querySelector(':root');
const WEBSOCKET_URL = 'ws://127.0.0.1:8080';
let websocket;

const animation_idle = document.getElementById('character_spritesheet_idle');
const animation_add_weapon = document.getElementById('character_spritesheet_add_weapon');
const animation_idle_weapon = document.getElementById('character_spritesheet_idle_weapon');
const animation_hit = document.getElementById('character_spritesheet_hit');
const animation_remove_weapon = document.getElementById('character_spritesheet_remove_weapon');

var audio = new Audio('knife.mp3');

function connectToWebsocket() {
    websocket = new WebSocket(WEBSOCKET_URL);
    websocket.onopen = () => subscribeToWebsocket();
    websocket.onmessage = event => eventReceived(JSON.parse(event.data));
    websocket.onclose = () => setTimeout(connectToWebsocket, 5000);
}

function subscribeToWebsocket() {
    websocket.send(
        JSON.stringify({
            "request": "Subscribe",
            "events": {
                "General": ["Custom"]
            },
            "id": "deathcounter"
        })
    );
    askForCurrentCounter();
}

function eventReceived(data) {
    if (data && data.status === 'ok') {
    } else if (data?.data?.data) {
        const widgetData = JSON.parse(data.data.data);
        if (widgetData.widget === 'DeathCounter') {
            if (widgetData.burn) {
                burnNumber(widgetData.counter);
            } else {
                setCurrentNumber(widgetData.counter, widgetData.animate);
            }
        }
    }
}

function setCurrentNumber(counter, animated) {
    if (animated) {
        const duration = [0, 1.5, 3, 4.5, 6, 7.5];
        for (let i = 0; i < duration.length; i++) {
            setTimeout(() => {
                setCurrentAnimation(i);
                if (i === duration.length - 3) {
                    animateSlicedCounter(counter);
                    document.getElementById('character').classList = '';
                } else if (i === duration.length - 4) {
                    document.getElementById('character').classList = 'scaled';
                    audio.play();
                }
            }, duration[i] * 1000);
        }
    } else {
        const number_div = document.getElementsByClassName('number');
        for (let index = 0; index < number_div.length; index++) {
            const element = number_div[index];
            element.innerHTML = counter;
        }
    }
}

function askForCurrentCounter() {
    var json = JSON.stringify({
        "request": "DoAction",
        "action": {
            "name": "DeathCounter"
        },
        "args": {
            "update": true,
        },
        "id": "deathCounterRead"
    });
    websocket.send(json);
}

function setCurrentAnimation(animation) {
    animation_idle.classList = animation === 5 ? '' : 'hidden';
    animation_add_weapon.classList = animation === 0 ? '' : 'hidden';
    animation_idle_weapon.classList = animation === 1 || animation === 3 ? '' : 'hidden';
    animation_hit.classList = animation === 2 ? '' : 'hidden';
    animation_remove_weapon.classList = animation === 4 ? '' : 'hidden';
}

function burnNumber(counter) {
    document.getElementById('fire').classList = 'display';
    setCurrentNumber('', false);

    setTimeout(() => {
        document.getElementById('fire').classList = '';
        setCurrentNumber(counter, false);
    }, 1000);
}

function animateSlicedCounter(counter) {
    const numberTopElement = document.getElementById("counter_top");
    numberTopElement.classList = 'counter sliced';

    setTimeout(() => {
        numberTopElement.classList = 'counter';
        setCurrentNumber(counter, false);
    }, 4000);
}

connectToWebsocket();